﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class Orders : BusinessBaseClass
    {

        public Orders()
        {
            OrdersDetailsList = new List<OrdersDetails>();
            OrdersPaymentList = new List<OrdersPayment>();
            OrdersTax = new List<OrdersTax>();
        }

        public Orders(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrdersID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("OrdersID"));
            OrderFrom = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrderFrom")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("OrderFrom"));
            UsersAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UsersAccountID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("UsersAccountID"));
            FirstName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("FirstName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("FirstName"));
            LastName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("LastName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("LastName"));
            Email = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Email")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Email"));
            Company = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Company")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Company"));
            BillingAddress1 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingAddress1")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingAddress1"));
            BillingAddress2 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingAddress2")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingAddress2"));
            BillingCity = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingCity")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingCity"));
            BillingState = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingState")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingState"));
            BillingCountry = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingCountry")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingCountry"));
            BillingPostalCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingPostalCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingPostalCode"));
            BillingMobile = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingMobile")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingMobile"));
            BillingPhone = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingPhone")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingPhone"));
            ShippingAddress1 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingAddress1")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingAddress1"));
            ShippingAddress2 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingAddress2")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingAddress2"));
            ShippingCity = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingCity")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingCity"));
            ShippingState = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingState")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingState"));
            ShippingCountry = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingCountry")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingCountry"));
            ShippingPostalCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingPostalCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingPostalCode"));
            ShippingMobile = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingMobile")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingMobile"));
            ShippingPhone = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingPhone")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingPhone"));
            IsShipToBillingAddress = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsShipToBillingAddress")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsShipToBillingAddress"));
            SubTotal = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("SubTotal")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("SubTotal"));
            Discount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Discount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Discount"));
            Shipping = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Shipping")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Shipping"));
            TotalBeforeGST = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TotalBeforeGST")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("TotalBeforeGST"));
            GST = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("GST")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("GST"));
            Total = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Total")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Total"));
            PaidAmount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaidAmount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("PaidAmount"));
            PromoCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PromoCode"));
            PromoDiscountAmount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoDiscountAmount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("PromoDiscountAmount"));
            PaymentMethod = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaymentMethod")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PaymentMethod"));
            PaymentType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaymentType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PaymentType"));
            PaymentStatus = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PaymentStatus")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PaymentStatus"));
            TransactionReference = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TransactionReference")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TransactionReference"));
            Comments = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Comments")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Comments"));
            IsUrgentDelivery = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsUrgentDelivery")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsUrgentDelivery"));
            OrderNumber = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrderNumber")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("OrderNumber"));
            //DONumber = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DONumber")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DONumber"));
            InvoiceNo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("InvoiceNo")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("InvoiceNo"));
            QuotationReferenceID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("QuotationReferenceID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("QuotationReferenceID"));
            OrderStatus = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrderStatus")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("OrderStatus"));
            AdminUserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            EarliestAvailableDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("EarliestAvailableDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("EarliestAvailableDate"));
            DeliveryTime = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DeliveryTime")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DeliveryTime"));
            ShippingOption = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingOption")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingOption"));
            DesignerName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DesignerName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DesignerName"));
            DesignerRemarks = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DesignerRemarks")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DesignerRemarks"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            ServiceTax = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ServiceTax")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("ServiceTax"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
            TotalDiscount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TotalDiscount")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("TotalDiscount"));
            HappyHoursDiscount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("HappyHoursDiscount")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("HappyHoursDiscount"));
            TableNumber = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TableNumber")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TableNumber"));

            DiscountType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DiscountType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DiscountType"));
            DiscountValue = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DiscountValue")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("DiscountValue"));
            ServiceTaxType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ServiceTaxType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ServiceTaxType"));
            ServiceTaxValue = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ServiceTaxValue")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("ServiceTaxValue"));
            RoundedAmount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("RoundedAmount")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("RoundedAmount"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public string TableNumber { get; set; }

        public string OrderFrom { get; set; }

        public Guid UsersAccountID { get; set; }

        public string FirstName { get; set; }

        public string LastName { get; set; }

        public string Email { get; set; }

        public string Company { get; set; }

        public string BillingAddress1 { get; set; }

        public string BillingAddress2 { get; set; }

        public string BillingCity { get; set; }

        public string BillingState { get; set; }

        public string BillingCountry { get; set; }

        public string BillingPostalCode { get; set; }

        public string BillingMobile { get; set; }

        public string BillingPhone { get; set; }

        public string ShippingAddress1 { get; set; }

        public string ShippingAddress2 { get; set; }

        public string ShippingCity { get; set; }

        public string ShippingState { get; set; }

        public string ShippingCountry { get; set; }

        public string ShippingPostalCode { get; set; }

        public string ShippingMobile { get; set; }

        public string ShippingPhone { get; set; }

        public bool IsShipToBillingAddress { get; set; }

        public decimal SubTotal { get; set; }

        public decimal Discount { get; set; }

        public decimal Shipping { get; set; }

        public decimal TotalBeforeGST { get; set; }

        public decimal GST { get; set; }

        public decimal ServiceTax { get; set; }

        public decimal Total { get; set; }

        public decimal PaidAmount { get; set; }

        public string PromoCode { get; set; }

        public decimal PromoDiscountAmount { get; set; }

        public string PaymentMethod { get; set; }

        public string PaymentType { get; set; }

        public string PaymentStatus { get; set; }

        public string TransactionReference { get; set; }

        public string Comments { get; set; }

        public bool IsUrgentDelivery { get; set; }

        public string OrderNumber { get; set; }

        //public string DONumber { get; set; }

        public string InvoiceNo { get; set; }

        public Guid QuotationReferenceID { get; set; }

        public string OrderStatus { get; set; }

        public DateTime EarliestAvailableDate { get; set; }

        public string DeliveryTime { get; set; }

        public string ShippingOption { get; set; }

        public string DesignerName { get; set; }

        public string DesignerRemarks { get; set; }

        public Guid AdminUserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }

        public decimal TotalDiscount { get; set; }

        public decimal HappyHoursDiscount { get; set; }

        //public override bool IsDeleted { get; set; }

        public List<OrdersDetails> OrdersDetailsList;

        public List<OrdersPayment> OrdersPaymentList;

        public List<OrdersTax> OrdersTax;

        public string DiscountType { get; set; }

        public decimal DiscountValue { get; set; }

        public string ServiceTaxType { get; set; }

        public decimal ServiceTaxValue { get; set; }

        public decimal RoundedAmount { get; set; }
    }
}
